<?php
function encryptToken($input) {
    // Base64 Encode
    $encoded = base64_encode($input);

    // Custom Vowel Replacement
    $obfuscated = str_replace(['a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U'], ['w%sy5f', 'p#r9v2', 'm&j4q8', 't!k7w3', 'z@x6n0', 'W%SY5F', 'P#R9V2', 'M&J4Q8', 'T!K7W3', 'Z@X6N0' ], $encoded);

    return $obfuscated;
}

function decryptToken($input) {
    // Validate input is not empty
    if (empty($input)) {
        return false;
    }

    // Reverse Custom Vowel Replacement
    $decoded_vowels = str_replace(['w%sy5f', 'p#r9v2', 'm&j4q8', 't!k7w3', 'z@x6n0', 'W%SY5F', 'P#R9V2', 'M&J4Q8', 'T!K7W3', 'Z@X6N0' ], ['a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U'], $input);

    // Validate Base64 string before decoding
    if (empty($decoded_vowels)) {
        return false;
    }

    // Base64 Decode with strict validation
    $original = base64_decode($decoded_vowels, true); // strict mode
    
    // Check if decode was successful
    if ($original === false || empty($original)) {
        return false;
    }

    return $original;
}
?>